/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class WoodlandMansionPieces {
    public static void m_73691_(StructureManager p_73692_, BlockPos p_73693_, Rotation p_73694_, List<WoodlandMansionPiece> p_73695_, Random p_73696_) {
        MansionGrid $$5 = new MansionGrid(p_73696_);
        MansionPiecePlacer $$6 = new MansionPiecePlacer(p_73692_, p_73696_);
        $$6.m_73781_(p_73693_, p_73694_, p_73695_, $$5);
    }

    public static void m_163676_(String[] p_163677_) {
        Random $$1 = new Random();
        long $$2 = $$1.nextLong();
        System.out.println("Seed: " + $$2);
        $$1.setSeed($$2);
        MansionGrid $$3 = new MansionGrid($$1);
        $$3.m_163694_();
    }

    static class MansionGrid {
        private static final int f_163678_ = 11;
        private static final int f_163679_ = 0;
        private static final int f_163680_ = 1;
        private static final int f_163681_ = 2;
        private static final int f_163682_ = 3;
        private static final int f_163683_ = 4;
        private static final int f_163684_ = 5;
        private static final int f_163685_ = 65536;
        private static final int f_163686_ = 131072;
        private static final int f_163687_ = 262144;
        private static final int f_163688_ = 0x100000;
        private static final int f_163689_ = 0x200000;
        private static final int f_163690_ = 0x400000;
        private static final int f_163691_ = 0x800000;
        private static final int f_163692_ = 983040;
        private static final int f_163693_ = 65535;
        private final Random f_73728_;
        final SimpleGrid f_73729_;
        final SimpleGrid f_73730_;
        final SimpleGrid[] f_73731_;
        final int f_73732_;
        final int f_73733_;

        public MansionGrid(Random p_73735_) {
            this.f_73728_ = p_73735_;
            int $$1 = 11;
            this.f_73732_ = 7;
            this.f_73733_ = 4;
            this.f_73729_ = new SimpleGrid(11, 11, 5);
            this.f_73729_.m_73884_(this.f_73732_, this.f_73733_, this.f_73732_ + 1, this.f_73733_ + 1, 3);
            this.f_73729_.m_73884_(this.f_73732_ - 1, this.f_73733_, this.f_73732_ - 1, this.f_73733_ + 1, 2);
            this.f_73729_.m_73884_(this.f_73732_ + 2, this.f_73733_ - 2, this.f_73732_ + 3, this.f_73733_ + 3, 5);
            this.f_73729_.m_73884_(this.f_73732_ + 1, this.f_73733_ - 2, this.f_73732_ + 1, this.f_73733_ - 1, 1);
            this.f_73729_.m_73884_(this.f_73732_ + 1, this.f_73733_ + 2, this.f_73732_ + 1, this.f_73733_ + 3, 1);
            this.f_73729_.m_73875_(this.f_73732_ - 1, this.f_73733_ - 1, 1);
            this.f_73729_.m_73875_(this.f_73732_ - 1, this.f_73733_ + 2, 1);
            this.f_73729_.m_73884_(0, 0, 11, 1, 5);
            this.f_73729_.m_73884_(0, 9, 11, 11, 5);
            this.m_73750_(this.f_73729_, this.f_73732_, this.f_73733_ - 2, Direction.WEST, 6);
            this.m_73750_(this.f_73729_, this.f_73732_, this.f_73733_ + 3, Direction.WEST, 6);
            this.m_73750_(this.f_73729_, this.f_73732_ - 2, this.f_73733_ - 1, Direction.WEST, 3);
            this.m_73750_(this.f_73729_, this.f_73732_ - 2, this.f_73733_ + 2, Direction.WEST, 3);
            while (this.m_73738_(this.f_73729_)) {
            }
            this.f_73731_ = new SimpleGrid[3];
            this.f_73731_[0] = new SimpleGrid(11, 11, 5);
            this.f_73731_[1] = new SimpleGrid(11, 11, 5);
            this.f_73731_[2] = new SimpleGrid(11, 11, 5);
            this.m_73756_(this.f_73729_, this.f_73731_[0]);
            this.m_73756_(this.f_73729_, this.f_73731_[1]);
            this.f_73731_[0].m_73884_(this.f_73732_ + 1, this.f_73733_, this.f_73732_ + 1, this.f_73733_ + 1, 0x800000);
            this.f_73731_[1].m_73884_(this.f_73732_ + 1, this.f_73733_, this.f_73732_ + 1, this.f_73733_ + 1, 0x800000);
            this.f_73730_ = new SimpleGrid(this.f_73729_.f_73865_, this.f_73729_.f_73866_, 5);
            this.m_73759_();
            this.m_73756_(this.f_73730_, this.f_73731_[2]);
        }

        public static boolean m_73740_(SimpleGrid p_73741_, int p_73742_, int p_73743_) {
            int $$3 = p_73741_.m_73872_(p_73742_, p_73743_);
            return $$3 == 1 || $$3 == 2 || $$3 == 3 || $$3 == 4;
        }

        public boolean m_73744_(SimpleGrid p_73745_, int p_73746_, int p_73747_, int p_73748_, int p_73749_) {
            return (this.f_73731_[p_73748_].m_73872_(p_73746_, p_73747_) & 0xFFFF) == p_73749_;
        }

        @Nullable
        public Direction m_73762_(SimpleGrid p_73763_, int p_73764_, int p_73765_, int p_73766_, int p_73767_) {
            for (Direction $$5 : Direction.Plane.HORIZONTAL) {
                if (!this.m_73744_(p_73763_, p_73764_ + $$5.m_122429_(), p_73765_ + $$5.m_122431_(), p_73766_, p_73767_)) continue;
                return $$5;
            }
            return null;
        }

        private void m_73750_(SimpleGrid p_73751_, int p_73752_, int p_73753_, Direction p_73754_, int p_73755_) {
            if (p_73755_ <= 0) {
                return;
            }
            p_73751_.m_73875_(p_73752_, p_73753_, 1);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_(), p_73753_ + p_73754_.m_122431_(), 0, 1);
            for (int $$5 = 0; $$5 < 8; ++$$5) {
                Direction $$6 = Direction.m_122407_(this.f_73728_.nextInt(4));
                if ($$6 == p_73754_.m_122424_() || $$6 == Direction.EAST && this.f_73728_.nextBoolean()) continue;
                int $$7 = p_73752_ + p_73754_.m_122429_();
                int $$8 = p_73753_ + p_73754_.m_122431_();
                if (p_73751_.m_73872_($$7 + $$6.m_122429_(), $$8 + $$6.m_122431_()) != 0 || p_73751_.m_73872_($$7 + $$6.m_122429_() * 2, $$8 + $$6.m_122431_() * 2) != 0) continue;
                this.m_73750_(p_73751_, p_73752_ + p_73754_.m_122429_() + $$6.m_122429_(), p_73753_ + p_73754_.m_122431_() + $$6.m_122431_(), $$6, p_73755_ - 1);
                break;
            }
            Direction $$9 = p_73754_.m_122427_();
            Direction $$10 = p_73754_.m_122428_();
            p_73751_.m_73879_(p_73752_ + $$9.m_122429_(), p_73753_ + $$9.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + $$10.m_122429_(), p_73753_ + $$10.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_() + $$9.m_122429_(), p_73753_ + p_73754_.m_122431_() + $$9.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_() + $$10.m_122429_(), p_73753_ + p_73754_.m_122431_() + $$10.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_() * 2, p_73753_ + p_73754_.m_122431_() * 2, 0, 2);
            p_73751_.m_73879_(p_73752_ + $$9.m_122429_() * 2, p_73753_ + $$9.m_122431_() * 2, 0, 2);
            p_73751_.m_73879_(p_73752_ + $$10.m_122429_() * 2, p_73753_ + $$10.m_122431_() * 2, 0, 2);
        }

        private boolean m_73738_(SimpleGrid p_73739_) {
            boolean $$1 = false;
            for (int $$2 = 0; $$2 < p_73739_.f_73866_; ++$$2) {
                for (int $$3 = 0; $$3 < p_73739_.f_73865_; ++$$3) {
                    if (p_73739_.m_73872_($$3, $$2) != 0) continue;
                    int $$4 = 0;
                    $$4 += MansionGrid.m_73740_(p_73739_, $$3 + 1, $$2) ? 1 : 0;
                    $$4 += MansionGrid.m_73740_(p_73739_, $$3 - 1, $$2) ? 1 : 0;
                    $$4 += MansionGrid.m_73740_(p_73739_, $$3, $$2 + 1) ? 1 : 0;
                    if (($$4 += MansionGrid.m_73740_(p_73739_, $$3, $$2 - 1) ? 1 : 0) >= 3) {
                        p_73739_.m_73875_($$3, $$2, 2);
                        $$1 = true;
                        continue;
                    }
                    if ($$4 != 2) continue;
                    int $$5 = 0;
                    $$5 += MansionGrid.m_73740_(p_73739_, $$3 + 1, $$2 + 1) ? 1 : 0;
                    $$5 += MansionGrid.m_73740_(p_73739_, $$3 - 1, $$2 + 1) ? 1 : 0;
                    $$5 += MansionGrid.m_73740_(p_73739_, $$3 + 1, $$2 - 1) ? 1 : 0;
                    if (($$5 += MansionGrid.m_73740_(p_73739_, $$3 - 1, $$2 - 1) ? 1 : 0) > 1) continue;
                    p_73739_.m_73875_($$3, $$2, 2);
                    $$1 = true;
                }
            }
            return $$1;
        }

        private void m_73759_() {
            ArrayList $$0 = Lists.newArrayList();
            SimpleGrid $$1 = this.f_73731_[1];
            for (int $$2 = 0; $$2 < this.f_73730_.f_73866_; ++$$2) {
                for (int $$3 = 0; $$3 < this.f_73730_.f_73865_; ++$$3) {
                    int $$4 = $$1.m_73872_($$3, $$2);
                    int $$5 = $$4 & 0xF0000;
                    if ($$5 != 131072 || ($$4 & 0x200000) != 0x200000) continue;
                    $$0.add(new Tuple<Integer, Integer>($$3, $$2));
                }
            }
            if ($$0.isEmpty()) {
                this.f_73730_.m_73884_(0, 0, this.f_73730_.f_73865_, this.f_73730_.f_73866_, 5);
                return;
            }
            Tuple $$6 = (Tuple)$$0.get(this.f_73728_.nextInt($$0.size()));
            int $$7 = $$1.m_73872_((Integer)$$6.m_14418_(), (Integer)$$6.m_14419_());
            $$1.m_73875_((Integer)$$6.m_14418_(), (Integer)$$6.m_14419_(), $$7 | 0x400000);
            Direction $$8 = this.m_73762_(this.f_73729_, (Integer)$$6.m_14418_(), (Integer)$$6.m_14419_(), 1, $$7 & 0xFFFF);
            int $$9 = (Integer)$$6.m_14418_() + $$8.m_122429_();
            int $$10 = (Integer)$$6.m_14419_() + $$8.m_122431_();
            for (int $$11 = 0; $$11 < this.f_73730_.f_73866_; ++$$11) {
                for (int $$12 = 0; $$12 < this.f_73730_.f_73865_; ++$$12) {
                    if (!MansionGrid.m_73740_(this.f_73729_, $$12, $$11)) {
                        this.f_73730_.m_73875_($$12, $$11, 5);
                        continue;
                    }
                    if ($$12 == (Integer)$$6.m_14418_() && $$11 == (Integer)$$6.m_14419_()) {
                        this.f_73730_.m_73875_($$12, $$11, 3);
                        continue;
                    }
                    if ($$12 != $$9 || $$11 != $$10) continue;
                    this.f_73730_.m_73875_($$12, $$11, 3);
                    this.f_73731_[2].m_73875_($$12, $$11, 0x800000);
                }
            }
            ArrayList $$13 = Lists.newArrayList();
            for (Direction $$14 : Direction.Plane.HORIZONTAL) {
                if (this.f_73730_.m_73872_($$9 + $$14.m_122429_(), $$10 + $$14.m_122431_()) != 0) continue;
                $$13.add($$14);
            }
            if ($$13.isEmpty()) {
                this.f_73730_.m_73884_(0, 0, this.f_73730_.f_73865_, this.f_73730_.f_73866_, 5);
                $$1.m_73875_((Integer)$$6.m_14418_(), (Integer)$$6.m_14419_(), $$7);
                return;
            }
            Direction $$15 = (Direction)$$13.get(this.f_73728_.nextInt($$13.size()));
            this.m_73750_(this.f_73730_, $$9 + $$15.m_122429_(), $$10 + $$15.m_122431_(), $$15, 4);
            while (this.m_73738_(this.f_73730_)) {
            }
        }

        private void m_73756_(SimpleGrid p_73757_, SimpleGrid p_73758_) {
            ArrayList $$2 = Lists.newArrayList();
            for (int $$3 = 0; $$3 < p_73757_.f_73866_; ++$$3) {
                for (int $$4 = 0; $$4 < p_73757_.f_73865_; ++$$4) {
                    if (p_73757_.m_73872_($$4, $$3) != 2) continue;
                    $$2.add(new Tuple<Integer, Integer>($$4, $$3));
                }
            }
            Collections.shuffle($$2, this.f_73728_);
            int $$5 = 10;
            for (Tuple $$6 : $$2) {
                int $$8;
                int $$7 = (Integer)$$6.m_14418_();
                if (p_73758_.m_73872_($$7, $$8 = ((Integer)$$6.m_14419_()).intValue()) != 0) continue;
                int $$9 = $$7;
                int $$10 = $$7;
                int $$11 = $$8;
                int $$12 = $$8;
                int $$13 = 65536;
                if (p_73758_.m_73872_($$7 + 1, $$8) == 0 && p_73758_.m_73872_($$7, $$8 + 1) == 0 && p_73758_.m_73872_($$7 + 1, $$8 + 1) == 0 && p_73757_.m_73872_($$7 + 1, $$8) == 2 && p_73757_.m_73872_($$7, $$8 + 1) == 2 && p_73757_.m_73872_($$7 + 1, $$8 + 1) == 2) {
                    ++$$10;
                    ++$$12;
                    $$13 = 262144;
                } else if (p_73758_.m_73872_($$7 - 1, $$8) == 0 && p_73758_.m_73872_($$7, $$8 + 1) == 0 && p_73758_.m_73872_($$7 - 1, $$8 + 1) == 0 && p_73757_.m_73872_($$7 - 1, $$8) == 2 && p_73757_.m_73872_($$7, $$8 + 1) == 2 && p_73757_.m_73872_($$7 - 1, $$8 + 1) == 2) {
                    --$$9;
                    ++$$12;
                    $$13 = 262144;
                } else if (p_73758_.m_73872_($$7 - 1, $$8) == 0 && p_73758_.m_73872_($$7, $$8 - 1) == 0 && p_73758_.m_73872_($$7 - 1, $$8 - 1) == 0 && p_73757_.m_73872_($$7 - 1, $$8) == 2 && p_73757_.m_73872_($$7, $$8 - 1) == 2 && p_73757_.m_73872_($$7 - 1, $$8 - 1) == 2) {
                    --$$9;
                    --$$11;
                    $$13 = 262144;
                } else if (p_73758_.m_73872_($$7 + 1, $$8) == 0 && p_73757_.m_73872_($$7 + 1, $$8) == 2) {
                    ++$$10;
                    $$13 = 131072;
                } else if (p_73758_.m_73872_($$7, $$8 + 1) == 0 && p_73757_.m_73872_($$7, $$8 + 1) == 2) {
                    ++$$12;
                    $$13 = 131072;
                } else if (p_73758_.m_73872_($$7 - 1, $$8) == 0 && p_73757_.m_73872_($$7 - 1, $$8) == 2) {
                    --$$9;
                    $$13 = 131072;
                } else if (p_73758_.m_73872_($$7, $$8 - 1) == 0 && p_73757_.m_73872_($$7, $$8 - 1) == 2) {
                    --$$11;
                    $$13 = 131072;
                }
                int $$14 = this.f_73728_.nextBoolean() ? $$9 : $$10;
                int $$15 = this.f_73728_.nextBoolean() ? $$11 : $$12;
                int $$16 = 0x200000;
                if (!p_73757_.m_73892_($$14, $$15, 1)) {
                    $$14 = $$14 == $$9 ? $$10 : $$9;
                    int n = $$15 = $$15 == $$11 ? $$12 : $$11;
                    if (!p_73757_.m_73892_($$14, $$15, 1)) {
                        int n2 = $$15 = $$15 == $$11 ? $$12 : $$11;
                        if (!p_73757_.m_73892_($$14, $$15, 1)) {
                            $$14 = $$14 == $$9 ? $$10 : $$9;
                            int n3 = $$15 = $$15 == $$11 ? $$12 : $$11;
                            if (!p_73757_.m_73892_($$14, $$15, 1)) {
                                $$16 = 0;
                                $$14 = $$9;
                                $$15 = $$11;
                            }
                        }
                    }
                }
                for (int $$17 = $$11; $$17 <= $$12; ++$$17) {
                    for (int $$18 = $$9; $$18 <= $$10; ++$$18) {
                        if ($$18 == $$14 && $$17 == $$15) {
                            p_73758_.m_73875_($$18, $$17, 0x100000 | $$16 | $$13 | $$5);
                            continue;
                        }
                        p_73758_.m_73875_($$18, $$17, $$13 | $$5);
                    }
                }
                ++$$5;
            }
        }

        public void m_163694_() {
            for (int $$0 = 0; $$0 < 2; ++$$0) {
                SimpleGrid $$1 = $$0 == 0 ? this.f_73729_ : this.f_73730_;
                for (int $$2 = 0; $$2 < $$1.f_73866_; ++$$2) {
                    for (int $$3 = 0; $$3 < $$1.f_73865_; ++$$3) {
                        int $$4 = $$1.m_73872_($$3, $$2);
                        if ($$4 == 1) {
                            System.out.print("+");
                            continue;
                        }
                        if ($$4 == 4) {
                            System.out.print("x");
                            continue;
                        }
                        if ($$4 == 2) {
                            System.out.print("X");
                            continue;
                        }
                        if ($$4 == 3) {
                            System.out.print("O");
                            continue;
                        }
                        if ($$4 == 5) {
                            System.out.print("#");
                            continue;
                        }
                        System.out.print(" ");
                    }
                    System.out.println("");
                }
                System.out.println("");
            }
        }
    }

    static class MansionPiecePlacer {
        private final StructureManager f_73774_;
        private final Random f_73775_;
        private int f_73776_;
        private int f_73777_;

        public MansionPiecePlacer(StructureManager p_73779_, Random p_73780_) {
            this.f_73774_ = p_73779_;
            this.f_73775_ = p_73780_;
        }

        public void m_73781_(BlockPos p_73782_, Rotation p_73783_, List<WoodlandMansionPiece> p_73784_, MansionGrid p_73785_) {
            PlacementData $$4 = new PlacementData();
            $$4.f_73840_ = p_73782_;
            $$4.f_73839_ = p_73783_;
            $$4.f_73841_ = "wall_flat";
            PlacementData $$5 = new PlacementData();
            this.m_73786_(p_73784_, $$4);
            $$5.f_73840_ = $$4.f_73840_.m_6630_(8);
            $$5.f_73839_ = $$4.f_73839_;
            $$5.f_73841_ = "wall_window";
            if (!p_73784_.isEmpty()) {
                // empty if block
            }
            SimpleGrid $$6 = p_73785_.f_73729_;
            SimpleGrid $$7 = p_73785_.f_73730_;
            this.f_73776_ = p_73785_.f_73732_ + 1;
            this.f_73777_ = p_73785_.f_73733_ + 1;
            int $$8 = p_73785_.f_73732_ + 1;
            int $$9 = p_73785_.f_73733_;
            this.m_73789_(p_73784_, $$4, $$6, Direction.SOUTH, this.f_73776_, this.f_73777_, $$8, $$9);
            this.m_73789_(p_73784_, $$5, $$6, Direction.SOUTH, this.f_73776_, this.f_73777_, $$8, $$9);
            PlacementData $$10 = new PlacementData();
            $$10.f_73840_ = $$4.f_73840_.m_6630_(19);
            $$10.f_73839_ = $$4.f_73839_;
            $$10.f_73841_ = "wall_window";
            boolean $$11 = false;
            for (int $$12 = 0; $$12 < $$7.f_73866_ && !$$11; ++$$12) {
                for (int $$13 = $$7.f_73865_ - 1; $$13 >= 0 && !$$11; --$$13) {
                    if (!MansionGrid.m_73740_($$7, $$13, $$12)) continue;
                    $$10.f_73840_ = $$10.f_73840_.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 8 + ($$12 - this.f_73777_) * 8);
                    $$10.f_73840_ = $$10.f_73840_.m_5484_(p_73783_.m_55954_(Direction.EAST), ($$13 - this.f_73776_) * 8);
                    this.m_73830_(p_73784_, $$10);
                    this.m_73789_(p_73784_, $$10, $$7, Direction.SOUTH, $$13, $$12, $$13, $$12);
                    $$11 = true;
                }
            }
            this.m_73803_(p_73784_, p_73782_.m_6630_(16), p_73783_, $$6, $$7);
            this.m_73803_(p_73784_, p_73782_.m_6630_(27), p_73783_, $$7, null);
            if (!p_73784_.isEmpty()) {
                // empty if block
            }
            FloorRoomCollection[] $$14 = new FloorRoomCollection[]{new FirstFloorRoomCollection(), new SecondFloorRoomCollection(), new ThirdFloorRoomCollection()};
            for (int $$15 = 0; $$15 < 3; ++$$15) {
                BlockPos $$16 = p_73782_.m_6630_(8 * $$15 + ($$15 == 2 ? 3 : 0));
                SimpleGrid $$17 = p_73785_.f_73731_[$$15];
                SimpleGrid $$18 = $$15 == 2 ? $$7 : $$6;
                String $$19 = $$15 == 0 ? "carpet_south_1" : "carpet_south_2";
                String $$20 = $$15 == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int $$21 = 0; $$21 < $$18.f_73866_; ++$$21) {
                    for (int $$22 = 0; $$22 < $$18.f_73865_; ++$$22) {
                        if ($$18.m_73872_($$22, $$21) != 1) continue;
                        BlockPos $$23 = $$16.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 8 + ($$21 - this.f_73777_) * 8);
                        $$23 = $$23.m_5484_(p_73783_.m_55954_(Direction.EAST), ($$22 - this.f_73776_) * 8);
                        p_73784_.add(new WoodlandMansionPiece(this.f_73774_, "corridor_floor", $$23, p_73783_));
                        if ($$18.m_73872_($$22, $$21 - 1) == 1 || ($$17.m_73872_($$22, $$21 - 1) & 0x800000) == 0x800000) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, "carpet_north", $$23.m_5484_(p_73783_.m_55954_(Direction.EAST), 1).m_7494_(), p_73783_));
                        }
                        if ($$18.m_73872_($$22 + 1, $$21) == 1 || ($$17.m_73872_($$22 + 1, $$21) & 0x800000) == 0x800000) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, "carpet_east", $$23.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 1).m_5484_(p_73783_.m_55954_(Direction.EAST), 5).m_7494_(), p_73783_));
                        }
                        if ($$18.m_73872_($$22, $$21 + 1) == 1 || ($$17.m_73872_($$22, $$21 + 1) & 0x800000) == 0x800000) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, $$19, $$23.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 5).m_5484_(p_73783_.m_55954_(Direction.WEST), 1), p_73783_));
                        }
                        if ($$18.m_73872_($$22 - 1, $$21) != 1 && ($$17.m_73872_($$22 - 1, $$21) & 0x800000) != 0x800000) continue;
                        p_73784_.add(new WoodlandMansionPiece(this.f_73774_, $$20, $$23.m_5484_(p_73783_.m_55954_(Direction.WEST), 1).m_5484_(p_73783_.m_55954_(Direction.NORTH), 1), p_73783_));
                    }
                }
                String $$24 = $$15 == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String $$25 = $$15 == 0 ? "indoors_door_1" : "indoors_door_2";
                ArrayList $$26 = Lists.newArrayList();
                for (int $$27 = 0; $$27 < $$18.f_73866_; ++$$27) {
                    for (int $$28 = 0; $$28 < $$18.f_73865_; ++$$28) {
                        boolean $$29;
                        boolean bl = $$29 = $$15 == 2 && $$18.m_73872_($$28, $$27) == 3;
                        if ($$18.m_73872_($$28, $$27) != 2 && !$$29) continue;
                        int $$30 = $$17.m_73872_($$28, $$27);
                        int $$31 = $$30 & 0xF0000;
                        int $$32 = $$30 & 0xFFFF;
                        $$29 = $$29 && ($$30 & 0x800000) == 0x800000;
                        $$26.clear();
                        if (($$30 & 0x200000) == 0x200000) {
                            for (Direction $$33 : Direction.Plane.HORIZONTAL) {
                                if ($$18.m_73872_($$28 + $$33.m_122429_(), $$27 + $$33.m_122431_()) != 1) continue;
                                $$26.add($$33);
                            }
                        }
                        Direction $$34 = null;
                        if (!$$26.isEmpty()) {
                            $$34 = (Direction)$$26.get(this.f_73775_.nextInt($$26.size()));
                        } else if (($$30 & 0x100000) == 0x100000) {
                            $$34 = Direction.UP;
                        }
                        BlockPos $$35 = $$16.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 8 + ($$27 - this.f_73777_) * 8);
                        $$35 = $$35.m_5484_(p_73783_.m_55954_(Direction.EAST), -1 + ($$28 - this.f_73776_) * 8);
                        if (MansionGrid.m_73740_($$18, $$28 - 1, $$27) && !p_73785_.m_73744_($$18, $$28 - 1, $$27, $$15, $$32)) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, $$34 == Direction.WEST ? $$25 : $$24, $$35, p_73783_));
                        }
                        if ($$18.m_73872_($$28 + 1, $$27) == 1 && !$$29) {
                            BlockPos $$36 = $$35.m_5484_(p_73783_.m_55954_(Direction.EAST), 8);
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, $$34 == Direction.EAST ? $$25 : $$24, $$36, p_73783_));
                        }
                        if (MansionGrid.m_73740_($$18, $$28, $$27 + 1) && !p_73785_.m_73744_($$18, $$28, $$27 + 1, $$15, $$32)) {
                            BlockPos $$37 = $$35.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 7);
                            $$37 = $$37.m_5484_(p_73783_.m_55954_(Direction.EAST), 7);
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, $$34 == Direction.SOUTH ? $$25 : $$24, $$37, p_73783_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if ($$18.m_73872_($$28, $$27 - 1) == 1 && !$$29) {
                            BlockPos $$38 = $$35.m_5484_(p_73783_.m_55954_(Direction.NORTH), 1);
                            $$38 = $$38.m_5484_(p_73783_.m_55954_(Direction.EAST), 7);
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, $$34 == Direction.NORTH ? $$25 : $$24, $$38, p_73783_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if ($$31 == 65536) {
                            this.m_73809_(p_73784_, $$35, p_73783_, $$34, $$14[$$15]);
                            continue;
                        }
                        if ($$31 == 131072 && $$34 != null) {
                            Direction $$39 = p_73785_.m_73762_($$18, $$28, $$27, $$15, $$32);
                            boolean $$40 = ($$30 & 0x400000) == 0x400000;
                            this.m_73822_(p_73784_, $$35, p_73783_, $$39, $$34, $$14[$$15], $$40);
                            continue;
                        }
                        if ($$31 == 262144 && $$34 != null && $$34 != Direction.UP) {
                            Direction $$41 = $$34.m_122427_();
                            if (!p_73785_.m_73744_($$18, $$28 + $$41.m_122429_(), $$27 + $$41.m_122431_(), $$15, $$32)) {
                                $$41 = $$41.m_122424_();
                            }
                            this.m_73815_(p_73784_, $$35, p_73783_, $$41, $$34, $$14[$$15]);
                            continue;
                        }
                        if ($$31 != 262144 || $$34 != Direction.UP) continue;
                        this.m_73798_(p_73784_, $$35, p_73783_, $$14[$$15]);
                    }
                }
            }
        }

        private void m_73789_(List<WoodlandMansionPiece> p_73790_, PlacementData p_73791_, SimpleGrid p_73792_, Direction p_73793_, int p_73794_, int p_73795_, int p_73796_, int p_73797_) {
            int $$8 = p_73794_;
            int $$9 = p_73795_;
            Direction $$10 = p_73793_;
            do {
                if (!MansionGrid.m_73740_(p_73792_, $$8 + p_73793_.m_122429_(), $$9 + p_73793_.m_122431_())) {
                    this.m_73833_(p_73790_, p_73791_);
                    p_73793_ = p_73793_.m_122427_();
                    if ($$8 == p_73796_ && $$9 == p_73797_ && $$10 == p_73793_) continue;
                    this.m_73830_(p_73790_, p_73791_);
                    continue;
                }
                if (MansionGrid.m_73740_(p_73792_, $$8 + p_73793_.m_122429_(), $$9 + p_73793_.m_122431_()) && MansionGrid.m_73740_(p_73792_, $$8 + p_73793_.m_122429_() + p_73793_.m_122428_().m_122429_(), $$9 + p_73793_.m_122431_() + p_73793_.m_122428_().m_122431_())) {
                    this.m_73836_(p_73790_, p_73791_);
                    $$8 += p_73793_.m_122429_();
                    $$9 += p_73793_.m_122431_();
                    p_73793_ = p_73793_.m_122428_();
                    continue;
                }
                if (($$8 += p_73793_.m_122429_()) == p_73796_ && ($$9 += p_73793_.m_122431_()) == p_73797_ && $$10 == p_73793_) continue;
                this.m_73830_(p_73790_, p_73791_);
            } while ($$8 != p_73796_ || $$9 != p_73797_ || $$10 != p_73793_);
        }

        private void m_73803_(List<WoodlandMansionPiece> p_73804_, BlockPos p_73805_, Rotation p_73806_, SimpleGrid p_73807_, @Nullable SimpleGrid p_73808_) {
            for (int $$5 = 0; $$5 < p_73807_.f_73866_; ++$$5) {
                for (int $$6 = 0; $$6 < p_73807_.f_73865_; ++$$6) {
                    boolean $$8;
                    BlockPos $$7 = p_73805_;
                    $$7 = $$7.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8 + ($$5 - this.f_73777_) * 8);
                    $$7 = $$7.m_5484_(p_73806_.m_55954_(Direction.EAST), ($$6 - this.f_73776_) * 8);
                    boolean bl = $$8 = p_73808_ != null && MansionGrid.m_73740_(p_73808_, $$6, $$5);
                    if (!MansionGrid.m_73740_(p_73807_, $$6, $$5) || $$8) continue;
                    p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof", $$7.m_6630_(3), p_73806_));
                    if (!MansionGrid.m_73740_(p_73807_, $$6 + 1, $$5)) {
                        BlockPos $$9 = $$7.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", $$9, p_73806_));
                    }
                    if (!MansionGrid.m_73740_(p_73807_, $$6 - 1, $$5)) {
                        BlockPos $$10 = $$7.m_5484_(p_73806_.m_55954_(Direction.EAST), 0);
                        $$10 = $$10.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 7);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", $$10, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                    }
                    if (!MansionGrid.m_73740_(p_73807_, $$6, $$5 - 1)) {
                        BlockPos $$11 = $$7.m_5484_(p_73806_.m_55954_(Direction.WEST), 1);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", $$11, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (MansionGrid.m_73740_(p_73807_, $$6, $$5 + 1)) continue;
                    BlockPos $$12 = $$7.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                    $$12 = $$12.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                    p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", $$12, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                }
            }
            if (p_73808_ != null) {
                for (int $$13 = 0; $$13 < p_73807_.f_73866_; ++$$13) {
                    for (int $$14 = 0; $$14 < p_73807_.f_73865_; ++$$14) {
                        BlockPos $$15 = p_73805_;
                        $$15 = $$15.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8 + ($$13 - this.f_73777_) * 8);
                        $$15 = $$15.m_5484_(p_73806_.m_55954_(Direction.EAST), ($$14 - this.f_73776_) * 8);
                        boolean $$16 = MansionGrid.m_73740_(p_73808_, $$14, $$13);
                        if (!MansionGrid.m_73740_(p_73807_, $$14, $$13) || !$$16) continue;
                        if (!MansionGrid.m_73740_(p_73807_, $$14 + 1, $$13)) {
                            BlockPos $$17 = $$15.m_5484_(p_73806_.m_55954_(Direction.EAST), 7);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", $$17, p_73806_));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, $$14 - 1, $$13)) {
                            BlockPos $$18 = $$15.m_5484_(p_73806_.m_55954_(Direction.WEST), 1);
                            $$18 = $$18.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", $$18, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, $$14, $$13 - 1)) {
                            BlockPos $$19 = $$15.m_5484_(p_73806_.m_55954_(Direction.WEST), 0);
                            $$19 = $$19.m_5484_(p_73806_.m_55954_(Direction.NORTH), 1);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", $$19, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, $$14, $$13 + 1)) {
                            BlockPos $$20 = $$15.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                            $$20 = $$20.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 7);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", $$20, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, $$14 + 1, $$13)) {
                            if (!MansionGrid.m_73740_(p_73807_, $$14, $$13 - 1)) {
                                BlockPos $$21 = $$15.m_5484_(p_73806_.m_55954_(Direction.EAST), 7);
                                $$21 = $$21.m_5484_(p_73806_.m_55954_(Direction.NORTH), 2);
                                p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", $$21, p_73806_));
                            }
                            if (!MansionGrid.m_73740_(p_73807_, $$14, $$13 + 1)) {
                                BlockPos $$22 = $$15.m_5484_(p_73806_.m_55954_(Direction.EAST), 8);
                                $$22 = $$22.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 7);
                                p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", $$22, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                            }
                        }
                        if (MansionGrid.m_73740_(p_73807_, $$14 - 1, $$13)) continue;
                        if (!MansionGrid.m_73740_(p_73807_, $$14, $$13 - 1)) {
                            BlockPos $$23 = $$15.m_5484_(p_73806_.m_55954_(Direction.WEST), 2);
                            $$23 = $$23.m_5484_(p_73806_.m_55954_(Direction.NORTH), 1);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", $$23, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (MansionGrid.m_73740_(p_73807_, $$14, $$13 + 1)) continue;
                        BlockPos $$24 = $$15.m_5484_(p_73806_.m_55954_(Direction.WEST), 1);
                        $$24 = $$24.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", $$24, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                    }
                }
            }
            for (int $$25 = 0; $$25 < p_73807_.f_73866_; ++$$25) {
                for (int $$26 = 0; $$26 < p_73807_.f_73865_; ++$$26) {
                    boolean $$28;
                    BlockPos $$27 = p_73805_;
                    $$27 = $$27.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8 + ($$25 - this.f_73777_) * 8);
                    $$27 = $$27.m_5484_(p_73806_.m_55954_(Direction.EAST), ($$26 - this.f_73776_) * 8);
                    boolean bl = $$28 = p_73808_ != null && MansionGrid.m_73740_(p_73808_, $$26, $$25);
                    if (!MansionGrid.m_73740_(p_73807_, $$26, $$25) || $$28) continue;
                    if (!MansionGrid.m_73740_(p_73807_, $$26 + 1, $$25)) {
                        BlockPos $$29 = $$27.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                        if (!MansionGrid.m_73740_(p_73807_, $$26, $$25 + 1)) {
                            BlockPos $$30 = $$29.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", $$30, p_73806_));
                        } else if (MansionGrid.m_73740_(p_73807_, $$26 + 1, $$25 + 1)) {
                            BlockPos $$31 = $$29.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 5);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", $$31, p_73806_));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, $$26, $$25 - 1)) {
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", $$29, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        } else if (MansionGrid.m_73740_(p_73807_, $$26 + 1, $$25 - 1)) {
                            BlockPos $$32 = $$27.m_5484_(p_73806_.m_55954_(Direction.EAST), 9);
                            $$32 = $$32.m_5484_(p_73806_.m_55954_(Direction.NORTH), 2);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", $$32, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                    }
                    if (MansionGrid.m_73740_(p_73807_, $$26 - 1, $$25)) continue;
                    BlockPos $$33 = $$27.m_5484_(p_73806_.m_55954_(Direction.EAST), 0);
                    $$33 = $$33.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 0);
                    if (!MansionGrid.m_73740_(p_73807_, $$26, $$25 + 1)) {
                        BlockPos $$34 = $$33.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", $$34, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                    } else if (MansionGrid.m_73740_(p_73807_, $$26 - 1, $$25 + 1)) {
                        BlockPos $$35 = $$33.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8);
                        $$35 = $$35.m_5484_(p_73806_.m_55954_(Direction.WEST), 3);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", $$35, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!MansionGrid.m_73740_(p_73807_, $$26, $$25 - 1)) {
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", $$33, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!MansionGrid.m_73740_(p_73807_, $$26 - 1, $$25 - 1)) continue;
                    BlockPos $$36 = $$33.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 1);
                    p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", $$36, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                }
            }
        }

        private void m_73786_(List<WoodlandMansionPiece> p_73787_, PlacementData p_73788_) {
            Direction $$2 = p_73788_.f_73839_.m_55954_(Direction.WEST);
            p_73787_.add(new WoodlandMansionPiece(this.f_73774_, "entrance", p_73788_.f_73840_.m_5484_($$2, 9), p_73788_.f_73839_));
            p_73788_.f_73840_ = p_73788_.f_73840_.m_5484_(p_73788_.f_73839_.m_55954_(Direction.SOUTH), 16);
        }

        private void m_73830_(List<WoodlandMansionPiece> p_73831_, PlacementData p_73832_) {
            p_73831_.add(new WoodlandMansionPiece(this.f_73774_, p_73832_.f_73841_, p_73832_.f_73840_.m_5484_(p_73832_.f_73839_.m_55954_(Direction.EAST), 7), p_73832_.f_73839_));
            p_73832_.f_73840_ = p_73832_.f_73840_.m_5484_(p_73832_.f_73839_.m_55954_(Direction.SOUTH), 8);
        }

        private void m_73833_(List<WoodlandMansionPiece> p_73834_, PlacementData p_73835_) {
            p_73835_.f_73840_ = p_73835_.f_73840_.m_5484_(p_73835_.f_73839_.m_55954_(Direction.SOUTH), -1);
            p_73834_.add(new WoodlandMansionPiece(this.f_73774_, "wall_corner", p_73835_.f_73840_, p_73835_.f_73839_));
            p_73835_.f_73840_ = p_73835_.f_73840_.m_5484_(p_73835_.f_73839_.m_55954_(Direction.SOUTH), -7);
            p_73835_.f_73840_ = p_73835_.f_73840_.m_5484_(p_73835_.f_73839_.m_55954_(Direction.WEST), -6);
            p_73835_.f_73839_ = p_73835_.f_73839_.m_55952_(Rotation.CLOCKWISE_90);
        }

        private void m_73836_(List<WoodlandMansionPiece> p_73837_, PlacementData p_73838_) {
            p_73838_.f_73840_ = p_73838_.f_73840_.m_5484_(p_73838_.f_73839_.m_55954_(Direction.SOUTH), 6);
            p_73838_.f_73840_ = p_73838_.f_73840_.m_5484_(p_73838_.f_73839_.m_55954_(Direction.EAST), 8);
            p_73838_.f_73839_ = p_73838_.f_73839_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
        }

        private void m_73809_(List<WoodlandMansionPiece> p_73810_, BlockPos p_73811_, Rotation p_73812_, Direction p_73813_, FloorRoomCollection p_73814_) {
            Rotation $$5 = Rotation.NONE;
            String $$6 = p_73814_.m_7668_(this.f_73775_);
            if (p_73813_ != Direction.EAST) {
                if (p_73813_ == Direction.NORTH) {
                    $$5 = $$5.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                } else if (p_73813_ == Direction.WEST) {
                    $$5 = $$5.m_55952_(Rotation.CLOCKWISE_180);
                } else if (p_73813_ == Direction.SOUTH) {
                    $$5 = $$5.m_55952_(Rotation.CLOCKWISE_90);
                } else {
                    $$6 = p_73814_.m_7669_(this.f_73775_);
                }
            }
            BlockPos $$7 = StructureTemplate.m_74587_(new BlockPos(1, 0, 0), Mirror.NONE, $$5, 7, 7);
            $$5 = $$5.m_55952_(p_73812_);
            $$7 = $$7.m_7954_(p_73812_);
            BlockPos $$8 = p_73811_.m_142082_($$7.m_123341_(), 0, $$7.m_123343_());
            p_73810_.add(new WoodlandMansionPiece(this.f_73774_, $$6, $$8, $$5));
        }

        private void m_73822_(List<WoodlandMansionPiece> p_73823_, BlockPos p_73824_, Rotation p_73825_, Direction p_73826_, Direction p_73827_, FloorRoomCollection p_73828_, boolean p_73829_) {
            if (p_73827_ == Direction.EAST && p_73826_ == Direction.SOUTH) {
                BlockPos $$7 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$7, p_73825_));
            } else if (p_73827_ == Direction.EAST && p_73826_ == Direction.NORTH) {
                BlockPos $$8 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                $$8 = $$8.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$8, p_73825_, Mirror.LEFT_RIGHT));
            } else if (p_73827_ == Direction.WEST && p_73826_ == Direction.NORTH) {
                BlockPos $$9 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                $$9 = $$9.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$9, p_73825_.m_55952_(Rotation.CLOCKWISE_180)));
            } else if (p_73827_ == Direction.WEST && p_73826_ == Direction.SOUTH) {
                BlockPos $$10 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$10, p_73825_, Mirror.FRONT_BACK));
            } else if (p_73827_ == Direction.SOUTH && p_73826_ == Direction.EAST) {
                BlockPos $$11 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$11, p_73825_.m_55952_(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT));
            } else if (p_73827_ == Direction.SOUTH && p_73826_ == Direction.WEST) {
                BlockPos $$12 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$12, p_73825_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_73827_ == Direction.NORTH && p_73826_ == Direction.WEST) {
                BlockPos $$13 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                $$13 = $$13.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$13, p_73825_.m_55952_(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK));
            } else if (p_73827_ == Direction.NORTH && p_73826_ == Direction.EAST) {
                BlockPos $$14 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                $$14 = $$14.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), $$14, p_73825_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_73827_ == Direction.SOUTH && p_73826_ == Direction.NORTH) {
                BlockPos $$15 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                $$15 = $$15.m_5484_(p_73825_.m_55954_(Direction.NORTH), 8);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), $$15, p_73825_));
            } else if (p_73827_ == Direction.NORTH && p_73826_ == Direction.SOUTH) {
                BlockPos $$16 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                $$16 = $$16.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 14);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), $$16, p_73825_.m_55952_(Rotation.CLOCKWISE_180)));
            } else if (p_73827_ == Direction.WEST && p_73826_ == Direction.EAST) {
                BlockPos $$17 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 15);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), $$17, p_73825_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_73827_ == Direction.EAST && p_73826_ == Direction.WEST) {
                BlockPos $$18 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.WEST), 7);
                $$18 = $$18.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), $$18, p_73825_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_73827_ == Direction.UP && p_73826_ == Direction.EAST) {
                BlockPos $$19 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 15);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_7672_(this.f_73775_), $$19, p_73825_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_73827_ == Direction.UP && p_73826_ == Direction.SOUTH) {
                BlockPos $$20 = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                $$20 = $$20.m_5484_(p_73825_.m_55954_(Direction.NORTH), 0);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_7672_(this.f_73775_), $$20, p_73825_));
            }
        }

        private void m_73815_(List<WoodlandMansionPiece> p_73816_, BlockPos p_73817_, Rotation p_73818_, Direction p_73819_, Direction p_73820_, FloorRoomCollection p_73821_) {
            int $$6 = 0;
            int $$7 = 0;
            Rotation $$8 = p_73818_;
            Mirror $$9 = Mirror.NONE;
            if (p_73820_ == Direction.EAST && p_73819_ == Direction.SOUTH) {
                $$6 = -7;
            } else if (p_73820_ == Direction.EAST && p_73819_ == Direction.NORTH) {
                $$6 = -7;
                $$7 = 6;
                $$9 = Mirror.LEFT_RIGHT;
            } else if (p_73820_ == Direction.NORTH && p_73819_ == Direction.EAST) {
                $$6 = 1;
                $$7 = 14;
                $$8 = p_73818_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
            } else if (p_73820_ == Direction.NORTH && p_73819_ == Direction.WEST) {
                $$6 = 7;
                $$7 = 14;
                $$8 = p_73818_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                $$9 = Mirror.LEFT_RIGHT;
            } else if (p_73820_ == Direction.SOUTH && p_73819_ == Direction.WEST) {
                $$6 = 7;
                $$7 = -8;
                $$8 = p_73818_.m_55952_(Rotation.CLOCKWISE_90);
            } else if (p_73820_ == Direction.SOUTH && p_73819_ == Direction.EAST) {
                $$6 = 1;
                $$7 = -8;
                $$8 = p_73818_.m_55952_(Rotation.CLOCKWISE_90);
                $$9 = Mirror.LEFT_RIGHT;
            } else if (p_73820_ == Direction.WEST && p_73819_ == Direction.NORTH) {
                $$6 = 15;
                $$7 = 6;
                $$8 = p_73818_.m_55952_(Rotation.CLOCKWISE_180);
            } else if (p_73820_ == Direction.WEST && p_73819_ == Direction.SOUTH) {
                $$6 = 15;
                $$9 = Mirror.FRONT_BACK;
            }
            BlockPos $$10 = p_73817_.m_5484_(p_73818_.m_55954_(Direction.EAST), $$6);
            $$10 = $$10.m_5484_(p_73818_.m_55954_(Direction.SOUTH), $$7);
            p_73816_.add(new WoodlandMansionPiece(this.f_73774_, p_73821_.m_7661_(this.f_73775_), $$10, $$8, $$9));
        }

        private void m_73798_(List<WoodlandMansionPiece> p_73799_, BlockPos p_73800_, Rotation p_73801_, FloorRoomCollection p_73802_) {
            BlockPos $$4 = p_73800_.m_5484_(p_73801_.m_55954_(Direction.EAST), 1);
            p_73799_.add(new WoodlandMansionPiece(this.f_73774_, p_73802_.m_7676_(this.f_73775_), $$4, p_73801_, Mirror.NONE));
        }
    }

    static class ThirdFloorRoomCollection
    extends SecondFloorRoomCollection {
        ThirdFloorRoomCollection() {
        }
    }

    static class SecondFloorRoomCollection
    extends FloorRoomCollection {
        SecondFloorRoomCollection() {
        }

        @Override
        public String m_7668_(Random p_73849_) {
            return "1x1_b" + (p_73849_.nextInt(4) + 1);
        }

        @Override
        public String m_7669_(Random p_73854_) {
            return "1x1_as" + (p_73854_.nextInt(4) + 1);
        }

        @Override
        public String m_5900_(Random p_73851_, boolean p_73852_) {
            if (p_73852_) {
                return "1x2_c_stairs";
            }
            return "1x2_c" + (p_73851_.nextInt(4) + 1);
        }

        @Override
        public String m_5899_(Random p_73856_, boolean p_73857_) {
            if (p_73857_) {
                return "1x2_d_stairs";
            }
            return "1x2_d" + (p_73856_.nextInt(5) + 1);
        }

        @Override
        public String m_7672_(Random p_73859_) {
            return "1x2_se" + (p_73859_.nextInt(1) + 1);
        }

        @Override
        public String m_7661_(Random p_73861_) {
            return "2x2_b" + (p_73861_.nextInt(5) + 1);
        }

        @Override
        public String m_7676_(Random p_73863_) {
            return "2x2_s1";
        }
    }

    static class FirstFloorRoomCollection
    extends FloorRoomCollection {
        FirstFloorRoomCollection() {
        }

        @Override
        public String m_7668_(Random p_73701_) {
            return "1x1_a" + (p_73701_.nextInt(5) + 1);
        }

        @Override
        public String m_7669_(Random p_73706_) {
            return "1x1_as" + (p_73706_.nextInt(4) + 1);
        }

        @Override
        public String m_5900_(Random p_73703_, boolean p_73704_) {
            return "1x2_a" + (p_73703_.nextInt(9) + 1);
        }

        @Override
        public String m_5899_(Random p_73708_, boolean p_73709_) {
            return "1x2_b" + (p_73708_.nextInt(5) + 1);
        }

        @Override
        public String m_7672_(Random p_73711_) {
            return "1x2_s" + (p_73711_.nextInt(2) + 1);
        }

        @Override
        public String m_7661_(Random p_73713_) {
            return "2x2_a" + (p_73713_.nextInt(4) + 1);
        }

        @Override
        public String m_7676_(Random p_73715_) {
            return "2x2_s1";
        }
    }

    static abstract class FloorRoomCollection {
        FloorRoomCollection() {
        }

        public abstract String m_7668_(Random var1);

        public abstract String m_7669_(Random var1);

        public abstract String m_5900_(Random var1, boolean var2);

        public abstract String m_5899_(Random var1, boolean var2);

        public abstract String m_7672_(Random var1);

        public abstract String m_7661_(Random var1);

        public abstract String m_7676_(Random var1);
    }

    static class SimpleGrid {
        private final int[][] f_73864_;
        final int f_73865_;
        final int f_73866_;
        private final int f_73867_;

        public SimpleGrid(int p_73869_, int p_73870_, int p_73871_) {
            this.f_73865_ = p_73869_;
            this.f_73866_ = p_73870_;
            this.f_73867_ = p_73871_;
            this.f_73864_ = new int[p_73869_][p_73870_];
        }

        public void m_73875_(int p_73876_, int p_73877_, int p_73878_) {
            if (p_73876_ >= 0 && p_73876_ < this.f_73865_ && p_73877_ >= 0 && p_73877_ < this.f_73866_) {
                this.f_73864_[p_73876_][p_73877_] = p_73878_;
            }
        }

        public void m_73884_(int p_73885_, int p_73886_, int p_73887_, int p_73888_, int p_73889_) {
            for (int $$5 = p_73886_; $$5 <= p_73888_; ++$$5) {
                for (int $$6 = p_73885_; $$6 <= p_73887_; ++$$6) {
                    this.m_73875_($$6, $$5, p_73889_);
                }
            }
        }

        public int m_73872_(int p_73873_, int p_73874_) {
            if (p_73873_ >= 0 && p_73873_ < this.f_73865_ && p_73874_ >= 0 && p_73874_ < this.f_73866_) {
                return this.f_73864_[p_73873_][p_73874_];
            }
            return this.f_73867_;
        }

        public void m_73879_(int p_73880_, int p_73881_, int p_73882_, int p_73883_) {
            if (this.m_73872_(p_73880_, p_73881_) == p_73882_) {
                this.m_73875_(p_73880_, p_73881_, p_73883_);
            }
        }

        public boolean m_73892_(int p_73893_, int p_73894_, int p_73895_) {
            return this.m_73872_(p_73893_ - 1, p_73894_) == p_73895_ || this.m_73872_(p_73893_ + 1, p_73894_) == p_73895_ || this.m_73872_(p_73893_, p_73894_ + 1) == p_73895_ || this.m_73872_(p_73893_, p_73894_ - 1) == p_73895_;
        }
    }

    static class PlacementData {
        public Rotation f_73839_;
        public BlockPos f_73840_;
        public String f_73841_;

        PlacementData() {
        }
    }

    public static class WoodlandMansionPiece
    extends TemplateStructurePiece {
        public WoodlandMansionPiece(StructureManager p_73905_, String p_73906_, BlockPos p_73907_, Rotation p_73908_) {
            this(p_73905_, p_73906_, p_73907_, p_73908_, Mirror.NONE);
        }

        public WoodlandMansionPiece(StructureManager p_73910_, String p_73911_, BlockPos p_73912_, Rotation p_73913_, Mirror p_73914_) {
            super(StructurePieceType.f_210120_, 0, p_73910_, WoodlandMansionPiece.m_163705_(p_73911_), p_73911_, WoodlandMansionPiece.m_163702_(p_73914_, p_73913_), p_73912_);
        }

        public WoodlandMansionPiece(StructureManager p_192693_, CompoundTag p_192694_) {
            super(StructurePieceType.f_210120_, p_192694_, p_192693_, (ResourceLocation p_163709_) -> WoodlandMansionPiece.m_163702_(Mirror.valueOf(p_192694_.m_128461_("Mi")), Rotation.valueOf(p_192694_.m_128461_("Rot"))));
        }

        @Override
        protected ResourceLocation m_142415_() {
            return WoodlandMansionPiece.m_163705_(this.f_163658_);
        }

        private static ResourceLocation m_163705_(String p_163706_) {
            return new ResourceLocation("woodland_mansion/" + p_163706_);
        }

        private static StructurePlaceSettings m_163702_(Mirror p_163703_, Rotation p_163704_) {
            return new StructurePlaceSettings().m_74392_(true).m_74379_(p_163704_).m_74377_(p_163703_).m_74383_(BlockIgnoreProcessor.f_74046_);
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192696_, CompoundTag p_192697_) {
            super.m_183620_(p_192696_, p_192697_);
            p_192697_.m_128359_("Rot", this.f_73657_.m_74404_().name());
            p_192697_.m_128359_("Mi", this.f_73657_.m_74401_().name());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void m_7756_(String p_73921_, BlockPos p_73922_, ServerLevelAccessor p_73923_, Random p_73924_, BoundingBox p_73925_) {
            if (p_73921_.startsWith("Chest")) {
                Rotation $$5 = this.f_73657_.m_74404_();
                BlockState $$6 = Blocks.f_50087_.m_49966_();
                if ("ChestWest".equals(p_73921_)) {
                    $$6 = (BlockState)$$6.m_61124_(ChestBlock.f_51478_, $$5.m_55954_(Direction.WEST));
                } else if ("ChestEast".equals(p_73921_)) {
                    $$6 = (BlockState)$$6.m_61124_(ChestBlock.f_51478_, $$5.m_55954_(Direction.EAST));
                } else if ("ChestSouth".equals(p_73921_)) {
                    $$6 = (BlockState)$$6.m_61124_(ChestBlock.f_51478_, $$5.m_55954_(Direction.SOUTH));
                } else if ("ChestNorth".equals(p_73921_)) {
                    $$6 = (BlockState)$$6.m_61124_(ChestBlock.f_51478_, $$5.m_55954_(Direction.NORTH));
                }
                this.m_73420_(p_73923_, p_73925_, p_73924_, p_73922_, BuiltInLootTables.f_78689_, $$6);
            } else {
                void $$9;
                switch (p_73921_) {
                    case "Mage": {
                        AbstractIllager $$7 = EntityType.f_20568_.m_20615_(p_73923_.m_6018_());
                        break;
                    }
                    case "Warrior": {
                        AbstractIllager $$8 = EntityType.f_20493_.m_20615_(p_73923_.m_6018_());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                $$9.m_21530_();
                $$9.m_20035_(p_73922_, 0.0f, 0.0f);
                $$9.m_6518_(p_73923_, p_73923_.m_6436_($$9.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                p_73923_.m_47205_((Entity)$$9);
                p_73923_.m_7731_(p_73922_, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }
}

